<?php

require_once __DIR__ . '/vendor/autoload.php';

// Bootstrap Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';

// Boot the application
$app->boot();

try {
    // Check if we can connect to the database
    $laptops = \App\Models\Laptop::select('id', 'barcode', 'asset_tag', 'brand', 'model')->get();
    
    echo "Found " . $laptops->count() . " laptops in database:\n\n";
    
    foreach ($laptops as $laptop) {
        echo "ID: {$laptop->id} | Barcode: {$laptop->barcode} | Asset Tag: {$laptop->asset_tag} | Brand: {$laptop->brand} | Model: {$laptop->model}\n";
    }
    
    // Specifically test for LT336113
    echo "\n\nLooking for barcode LT336113:\n";
    $testLaptop = \App\Models\Laptop::where('barcode', 'LT336113')->first();
    
    if ($testLaptop) {
        echo "FOUND! Laptop with barcode LT336113:\n";
        echo "ID: {$testLaptop->id}\n";
        echo "Asset Tag: {$testLaptop->asset_tag}\n";
        echo "Brand: {$testLaptop->brand}\n";
        echo "Model: {$testLaptop->model}\n";
        echo "Status: {$testLaptop->status}\n";
    } else {
        echo "NOT FOUND: No laptop found with barcode LT336113\n";
    }
    
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}