<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\LaptopController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\ClassRoomController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\UserController;

Route::get('/', function () {
    return view('welcome');
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/transactions/scan-process', [DashboardController::class, 'processBarcodeScann']);

    // Specific transaction routes (must come before resource routes)
    Route::get('/transactions/checkout/{student_id?}', [TransactionController::class, 'checkoutForm'])->name('transactions.checkout');
    Route::post('/transactions/checkout', [TransactionController::class, 'checkOut'])->name('transactions.checkout.store');
    Route::get('/transactions/checkin/{laptop_barcode?}', [TransactionController::class, 'checkinForm'])->name('transactions.checkin');
    Route::post('/transactions/checkin', [TransactionController::class, 'checkIn'])->name('transactions.checkin.store');
    Route::post('/transactions/scan-process', [TransactionController::class, 'scanProcess'])->name('transactions.scan-process');

    // Specific laptop routes (must come before resource routes)
    Route::post('/laptops/bulk-barcode-pdf', [LaptopController::class, 'bulkGenerateBarcodePdf'])->name('laptops.bulk-barcode-pdf');
    Route::get('/laptops/{id}/barcode-pdf', [LaptopController::class, 'generateBarcodePdf'])->name('laptops.barcode-pdf');

    // Resource routes
    Route::resource('laptops', LaptopController::class);
    Route::resource('students', StudentController::class);
    Route::resource('classes', ClassRoomController::class);
    Route::resource('transactions', TransactionController::class)->except(['edit', 'update', 'destroy', 'create', 'store']);

    Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
    Route::get('/reports/laptop-status', [ReportController::class, 'laptopStatus'])->name('reports.laptop-status');
    Route::get('/reports/class/{classId}', [ReportController::class, 'classReport'])->name('reports.class-report');
    Route::get('/reports/transaction-history', [ReportController::class, 'transactionHistory'])->name('reports.transaction-history');
    Route::get('/reports/export/{type}', [ReportController::class, 'exportPdf'])->name('reports.export-pdf');

    // Admin-only routes for user management
    Route::middleware(['admin'])->group(function () {
        Route::resource('users', UserController::class);
        Route::get('/user-activities', [UserController::class, 'activities'])->name('users.activities');
    });
});
