{{-- resources/views/transactions/show.blade.php --}}
@extends('layouts.base')

@section('content')
<div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            <!-- Header -->
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-2xl font-bold text-gray-900">
                    Transaction Details
                </h2>
                <a href="{{ route('transactions.index') }}"
                   class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md">
                    Back to Transactions
                </a>
            </div>

            <!-- Transaction Details -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Basic Information -->
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Transaction Information</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Transaction ID:</span>
                                <span class="font-medium">#{{ $transaction->id }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Type:</span>
                                <span class="font-medium capitalize {{ $transaction->type === 'check_out' ? 'text-blue-600' : 'text-green-600' }}">
                                    {{ str_replace('_', ' ', $transaction->type) }}
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Date & Time:</span>
                                <span class="font-medium">{{ $transaction->transaction_time->format('M d, Y \a\t H:i') }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Processed by:</span>
                                <span class="font-medium">{{ $transaction->user->name }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Condition Information -->
                    <div>
                        <h4 class="text-md font-semibold text-gray-900 mb-3">Condition Details</h4>
                        <div class="space-y-3">
                            @if($transaction->condition_before)
                            <div class="flex justify-between">
                                <span class="text-gray-600">Condition Before:</span>
                                <span class="font-medium capitalize">{{ $transaction->condition_before }}</span>
                            </div>
                            @endif
                            @if($transaction->condition_after)
                            <div class="flex justify-between">
                                <span class="text-gray-600">Condition After:</span>
                                <span class="font-medium capitalize">{{ $transaction->condition_after }}</span>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Notes -->
                    @if($transaction->notes)
                    <div>
                        <h4 class="text-md font-semibold text-gray-900 mb-3">Notes</h4>
                        <p class="text-gray-700 bg-gray-50 p-3 rounded-md">{{ $transaction->notes }}</p>
                    </div>
                    @endif
                </div>

                <!-- Laptop & Student Information -->
                <div class="space-y-6">
                    <!-- Laptop Information -->
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Laptop Information</h3>
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <div class="flex items-center space-x-3 mb-3">
                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="font-medium text-gray-900">{{ $transaction->laptop->brand }} {{ $transaction->laptop->model }}</h4>
                                    <p class="text-sm text-gray-600">{{ $transaction->laptop->asset_tag }}</p>
                                </div>
                            </div>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Barcode:</span>
                                    <span class="font-mono">{{ $transaction->laptop->barcode }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Serial Number:</span>
                                    <span class="font-mono">{{ $transaction->laptop->serial_number }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Class:</span>
                                    <span>{{ $transaction->laptop->class->name }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Student Information -->
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Student Information</h3>
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <div class="flex items-center space-x-3 mb-3">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="font-medium text-gray-900">{{ $transaction->student->full_name }}</h4>
                                    <p class="text-sm text-gray-600">ID: {{ $transaction->student->student_id }}</p>
                                </div>
                            </div>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Class:</span>
                                    <span>{{ $transaction->student->class->name }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Email:</span>
                                    <span>{{ $transaction->student->email ?: 'N/A' }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection