{{-- resources/views/students/show.blade.php --}}
@extends('layouts.base')

@section('content')
<div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            <!-- Header -->
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-2xl font-bold text-gray-900">
                    Student Details
                </h2>
                <div class="flex space-x-4">
                    <a href="{{ route('students.edit', $student) }}"
                       class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md">
                        Edit Student
                    </a>
                    <a href="{{ route('students.index') }}"
                       class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md">
                        Back to Students
                    </a>
                </div>
            </div>

            <!-- Student Information -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Basic Information -->
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Full Name:</span>
                                <span class="font-medium">{{ $student->full_name }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Student ID:</span>
                                <span class="font-medium">{{ $student->student_id }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Email:</span>
                                <span class="font-medium">{{ $student->email ?: 'N/A' }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Class:</span>
                                <span class="font-medium">{{ $student->class->name }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Status:</span>
                                <span class="font-medium">
                                    <span class="px-2 py-1 text-xs rounded-full {{ $student->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $student->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Current Assignment -->
                    @if($student->currentAssignment)
                    <div>
                        <h4 class="text-md font-semibold text-gray-900 mb-3">Current Laptop Assignment</h4>
                        <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                            <div class="flex items-center space-x-3 mb-3">
                                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                                    <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h5 class="font-medium text-gray-900">{{ $student->currentAssignment->laptop->brand }} {{ $student->currentAssignment->laptop->model }}</h5>
                                    <p class="text-sm text-gray-600">{{ $student->currentAssignment->laptop->asset_tag }}</p>
                                </div>
                            </div>
                            <div class="text-sm text-gray-600">
                                <p>Checked out: {{ $student->currentAssignment->checked_out_at->format('M d, Y \a\t H:i') }}</p>
                                <p>Barcode: {{ $student->currentAssignment->laptop->barcode }}</p>
                            </div>
                        </div>
                    </div>
                    @else
                    <div>
                        <h4 class="text-md font-semibold text-gray-900 mb-3">Current Status</h4>
                        <div class="bg-green-50 p-4 rounded-lg border border-green-200">
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h5 class="font-medium text-gray-900">No Active Assignment</h5>
                                    <p class="text-sm text-gray-600">Student is available for laptop assignment</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Transaction History -->
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Transactions</h3>
                        <div class="space-y-3">
                            @forelse($student->transactions()->latest()->take(5)->get() as $transaction)
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                <div class="flex items-center space-x-3">
                                    <div class="w-8 h-8 rounded-lg flex items-center justify-center
                                        {{ $transaction->type === 'check_out' ? 'bg-blue-100' : 'bg-green-100' }}">
                                        <svg class="w-4 h-4 {{ $transaction->type === 'check_out' ? 'text-blue-600' : 'text-green-600' }}"
                                             fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                  d="{{ $transaction->type === 'check_out' ? 'M12 4v16m8-8H4' : 'M5 13l4 4L19 7' }}"></path>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900 capitalize">{{ str_replace('_', ' ', $transaction->type) }}</p>
                                        <p class="text-sm text-gray-600">{{ $transaction->laptop->asset_tag }}</p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm font-medium text-gray-900">{{ $transaction->transaction_time->format('M d') }}</p>
                                    <p class="text-xs text-gray-500">{{ $transaction->transaction_time->format('H:i') }}</p>
                                </div>
                            </div>
                            @empty
                            <div class="text-center py-8 text-gray-500">
                                <svg class="w-12 h-12 mx-auto mb-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                                </svg>
                                <p>No transactions found</p>
                            </div>
                            @endforelse
                        </div>

                        @if($student->transactions()->count() > 5)
                        <div class="text-center mt-4">
                            <a href="{{ route('transactions.index', ['student_id' => $student->id]) }}"
                               class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                View all transactions →
                            </a>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection