{{-- resources/views/reports/class-report.blade.php --}}
@extends('layouts.base')

@section('content')
<div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            <!-- Header -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">Class Report: {{ $class->name }}</h2>
                    @if($class->grade_level)
                        <p class="text-gray-600">Grade {{ $class->grade_level }} {{ $class->section ? '- ' . $class->section : '' }}</p>
                    @endif
                </div>
                <div class="flex space-x-4">
                    <a href="{{ route('reports.export-pdf', ['type' => 'class', 'class_id' => $class->id]) }}"
                        class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md inline-flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Download PDF
                    </a>
                    <a href="{{ route('reports.index') }}"
                        class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md inline-flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                        Back to Reports
                    </a>
                    <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md inline-flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                        </svg>
                        Print Report
                    </button>
                </div>
            </div>

            <!-- Summary Stats -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8">
                <div class="bg-blue-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-blue-600">{{ $class->students()->count() }}</div>
                    <div class="text-sm text-blue-800">Total Students</div>
                </div>
                <div class="bg-green-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-green-600">{{ $laptops->where('status', 'available')->count() }}</div>
                    <div class="text-sm text-green-800">Available Laptops</div>
                </div>
                <div class="bg-yellow-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-yellow-600">{{ $laptops->where('status', 'checked_out')->count() }}</div>
                    <div class="text-sm text-yellow-800">Checked Out</div>
                </div>
                <div class="bg-red-50 p-4 rounded-lg">
                    <div class="text-2xl font-bold text-red-600">{{ $laptops->whereIn('status', ['maintenance', 'damaged'])->count() }}</div>
                    <div class="text-sm text-red-800">Issues</div>
                </div>
            </div>

            <!-- Laptops Table -->
            <div class="mb-8">
                <h3 class="text-lg font-semibold mb-4">Laptop Assignments</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Asset Tag</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Brand/Model</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Current Student</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Checked Out</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Serial Number</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($laptops as $laptop)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ $laptop->asset_tag }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $laptop->brand }} {{ $laptop->model }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                        {{ $laptop->status === 'available' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $laptop->status === 'checked_out' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $laptop->status === 'maintenance' ? 'bg-red-100 text-red-800' : '' }}
                                        {{ $laptop->status === 'damaged' ? 'bg-red-100 text-red-800' : '' }}">
                                        {{ ucfirst($laptop->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    @if($laptop->currentAssignment)
                                        {{ $laptop->currentAssignment->student->full_name }}
                                        <br>
                                        <span class="text-xs text-gray-400">{{ $laptop->currentAssignment->student->student_id }}</span>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    @if($laptop->currentAssignment)
                                        {{ $laptop->currentAssignment->checked_out_at->format('M d, Y H:i') }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $laptop->serial_number }}
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="px-6 py-4 text-center text-gray-500">
                                    No laptops assigned to this class.
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Students without laptops -->
            <div class="mb-8">
                <h3 class="text-lg font-semibold mb-4">Students without Laptops</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student ID</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @php
                                $studentsWithoutLaptops = $class->students->filter(function($student) {
                                    return !$student->currentAssignment;
                                });
                            @endphp
                            @forelse($studentsWithoutLaptops as $student)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ $student->student_id }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $student->full_name }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $student->email ?? '-' }}
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="3" class="px-6 py-4 text-center text-gray-500">
                                    All students have laptops assigned.
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Pagination -->
            <div class="mt-6">
                {{ $laptops->links() }}
            </div>

            <!-- Report Footer -->
            <div class="mt-8 pt-4 border-t border-gray-200 text-sm text-gray-500">
                <p>Report generated on {{ now()->format('F d, Y \a\t H:i') }} by {{ auth()->user()->name }}</p>
                <p>Class: {{ $class->name }} | Total Students: {{ $class->students()->count() }} | Total Laptops: {{ $laptops->count() }}</p>
            </div>
        </div>
    </div>
</div>

<style>
@media print {
    .no-print {
        display: none !important;
    }

    body {
        -webkit-print-color-adjust: exact;
    }

    .bg-white {
        background-color: white !important;
    }
}
</style>
@endsection