<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Riviera High School - Laptop Tracking') }}</title>

        <!-- Favicon -->
        <link rel="icon" type="image/x-icon" href="{{ asset('/images/favicon.ico') }}">
        <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('apple-touch-icon.png') }}">
        <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('/images/favicon-32x32.png') }}">
        <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('/images/favicon-16x16.png') }}">

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600,700&display=swap" rel="stylesheet" />

        <!-- Styles / Scripts -->
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/css/components.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
            <script>
                tailwind.config = {
                    theme: {
                        extend: {
                            fontFamily: {
                                sans: ['Instrument Sans', 'ui-sans-serif', 'system-ui', 'sans-serif'],
                            },
                            animation: {
                                'float': 'float 6s ease-in-out infinite',
                                'fade-in': 'fadeIn 1s ease-out',
                                'slide-up': 'slideUp 0.8s ease-out',
                            },
                            keyframes: {
                                float: {
                                    '0%, 100%': { transform: 'translateY(0px)' },
                                    '50%': { transform: 'translateY(-10px)' }
                                },
                                fadeIn: {
                                    'from': { opacity: '0', transform: 'translateY(20px)' },
                                    'to': { opacity: '1', transform: 'translateY(0)' }
                                },
                                slideUp: {
                                    'from': { opacity: '0', transform: 'translateY(30px)' },
                                    'to': { opacity: '1', transform: 'translateY(0)' }
                                }
                            }
                        }
                    }
                }
            </script>
        @endif

        <!-- Custom Styles -->
        <style>
            [x-cloak] { display: none !important; }
            .text-shadow {
                text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            }
            .glass-card {
                background: rgba(255, 255, 255, 0.95);
                backdrop-filter: blur(20px);
                border: 1px solid rgba(255, 255, 255, 0.2);
                box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
            }
            .input-modern {
                background: rgba(255, 255, 255, 0.8);
                border: 2px solid rgba(58, 120, 192, 0.2);
                transition: all 0.3s ease;
            }
            .input-modern:focus {
                border-color: #3A78C0;
                box-shadow: 0 0 0 3px rgba(58, 120, 192, 0.1);
                background: rgba(255, 255, 255, 0.95);
            }
            .btn-primary {
                background: linear-gradient(135deg, #4CAF50 0%, #3F8E44 100%);
                border: none;
                transition: all 0.3s ease;
            }
            .btn-primary:hover {
                background: linear-gradient(135deg, #3F8E44 0%, #2E7D32 100%);
                transform: translateY(-2px);
                box-shadow: 0 10px 25px rgba(76, 175, 80, 0.3);
            }
            .btn-secondary {
                background: linear-gradient(135deg, #FFD700 0%, #FBC02D 100%);
                border: none;
                color: #212121;
                transition: all 0.3s ease;
            }
            .btn-secondary:hover {
                background: linear-gradient(135deg, #FBC02D 0%, #F9A825 100%);
                transform: translateY(-2px);
                box-shadow: 0 10px 25px rgba(255, 215, 0, 0.3);
            }
        </style>

        <!-- Livewire Styles -->
        @livewireStyles
    </head>
    <body class="font-sans antialiased" style="background: linear-gradient(135deg, #3A78C0 0%, #4CAF50 50%, #3F8E44 100%); min-height: 100vh;">
        <!-- Animated Background -->
        <div class="fixed inset-0 overflow-hidden pointer-events-none">
            <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-blue-200 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-float"></div>
            <div class="absolute top-3/4 right-1/4 w-72 h-72 bg-green-200 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-float" style="animation-delay: 2s;"></div>
            <div class="absolute top-1/2 left-1/2 w-80 h-80 bg-indigo-200 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-float" style="animation-delay: 4s;"></div>
        </div>

        <div class="min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0 relative z-10">
            {{ $slot }}
        </div>

        @livewireScripts
    </body>
</html>
