{{-- resources/views/laptops/bulk-barcode-pdf.blade.php --}}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Bulk Barcodes - {{ date('Y-m-d') }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        .barcode-container {
            page-break-inside: avoid;
            margin: 20px 0;
            padding: 20px;
            border: 2px solid #000;
            display: inline-block;
            width: 45%;
            margin-right: 5%;
            vertical-align: top;
        }
        .barcode-container:nth-child(2n) {
            margin-right: 0;
        }
        .laptop-info {
            margin-bottom: 15px;
            text-align: center;
        }
        .barcode-image {
            text-align: center;
            margin: 15px 0;
        }
        .page-break {
            page-break-before: always;
        }
        @media print {
            .barcode-container {
                width: 48%;
                margin-right: 2%;
            }
            .barcode-container:nth-child(2n) {
                margin-right: 0;
            }
        }
    </style>
</head>
<body>
    <h1 style="text-align: center; margin-bottom: 30px;">Bulk Laptop Barcodes</h1>
    <p style="text-align: center; margin-bottom: 20px;">Generated on: {{ date('F d, Y \a\t H:i') }}</p>

    @foreach($laptops as $index => $laptop)
        @if($index > 0 && $index % 8 == 0)
            <div class="page-break"></div>
        @endif

        <div class="barcode-container">
            <div class="laptop-info">
                <h2 style="margin: 0; font-size: 16px;">{{ $laptop->asset_tag }}</h2>
                <p style="margin: 5px 0; font-size: 12px;"><strong>Brand:</strong> {{ $laptop->brand }}</p>
                <p style="margin: 5px 0; font-size: 12px;"><strong>Model:</strong> {{ $laptop->model }}</p>
                <p style="margin: 5px 0; font-size: 12px;"><strong>Class:</strong> {{ $laptop->class->name }}</p>

                @if($laptop->assigned_student_id || $laptop->assigned_student_name)
                    <div style="border-top: 1px solid #ccc; margin: 8px 0; padding-top: 8px;">
                        <h3 style="color: #2563eb; margin: 0 0 3px 0; font-size: 12px;">Assigned Student</h3>
                        @if($laptop->assigned_student_id)
                            <p style="margin: 2px 0; font-size: 11px;"><strong>ID:</strong> {{ $laptop->assigned_student_id }}</p>
                        @endif
                        @if($laptop->assigned_student_name)
                            <p style="margin: 2px 0; font-size: 11px;"><strong>Name:</strong> {{ $laptop->assigned_student_name }}</p>
                        @endif
                    </div>
                @endif

                @if($laptop->currentAssignment)
                    <div style="border-top: 1px solid #ccc; margin: 8px 0; padding-top: 8px;">
                        <h3 style="color: #dc2626; margin: 0 0 3px 0; font-size: 12px;">Currently Checked Out</h3>
                        <p style="margin: 2px 0; font-size: 11px;"><strong>Student:</strong> {{ $laptop->currentAssignment->student->full_name }}</p>
                        <p style="margin: 2px 0; font-size: 11px;"><strong>ID:</strong> {{ $laptop->currentAssignment->student->student_id }}</p>
                        <p style="margin: 2px 0; font-size: 11px;"><strong>Since:</strong> {{ $laptop->currentAssignment->checked_out_at->format('M d, Y H:i') }}</p>
                    </div>
                @endif
            </div>

            <div class="barcode-image">
                <img src="data:image/png;base64,{{ app('App\Services\BarcodeService')->generateBarcode($laptop->barcode) }}" alt="Barcode" style="max-width: 100%; height: auto;">
                <p style="margin: 10px 0; font-size: 12px;"><strong>Barcode:</strong> {{ $laptop->barcode }}</p>
            </div>
        </div>
    @endforeach
</body>
</html>