{{-- resources/views/dashboard.blade.php --}}
@extends('layouts.base')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100">
    <!-- Animated Background -->
    <div class="fixed inset-0 overflow-hidden pointer-events-none">
        <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-blue-200 rounded-full mix-blend-multiply filter blur-xl opacity-30 animate-float"></div>
        <div class="absolute top-3/4 right-1/4 w-72 h-72 bg-purple-200 rounded-full mix-blend-multiply filter blur-xl opacity-30 animate-float animation-delay-2000"></div>
        <div class="absolute top-1/2 left-1/2 w-80 h-80 bg-indigo-200 rounded-full mix-blend-multiply filter blur-xl opacity-30 animate-float animation-delay-4000"></div>
    </div>

    <!-- Main Content -->
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6 md:py-12">
        <!-- Header Section -->
        <div class="mb-12 animate-fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-4xl font-bold bg-gradient-to-r from-gray-900 via-blue-800 to-purple-800 bg-clip-text text-transparent mb-2">
                        Dashboard Overview
                    </h1>
                    <p class="text-lg text-gray-600">Real-time insights into your laptop inventory</p>
                </div>
                <div class="hidden md:flex items-center space-x-4">
                    <div class="flex items-center space-x-2 text-sm text-gray-500">
                        <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>
                        <span>Live Data</span>
                    </div>
                    <span class="text-sm text-gray-400">|</span>
                    <span class="text-sm text-gray-500">Updated just now</span>
                </div>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 md:gap-6 mb-8 md:mb-12">
            <!-- Total Laptops -->
            <div class="bg-white rounded-lg md:rounded-2xl p-4 md:p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs md:text-sm font-medium text-gray-600 mb-1">Total Laptops</p>
                        <p class="text-xl md:text-3xl font-bold text-gray-900">{{ $stats['total_laptops'] }}</p>
                        <p class="text-xs text-gray-500 mt-1 hidden sm:block">Active devices</p>
                    </div>
                    <div class="p-2 md:p-3 bg-blue-100 rounded-lg md:rounded-xl">
                        <svg class="w-4 h-4 md:w-6 md:h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Available -->
            <div class="bg-white rounded-lg md:rounded-2xl p-4 md:p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs md:text-sm font-medium text-gray-600 mb-1">Available</p>
                        <p class="text-xl md:text-3xl font-bold text-green-600">{{ $stats['available_laptops'] }}</p>
                        <p class="text-xs text-gray-500 mt-1 hidden sm:block">Ready for checkout</p>
                    </div>
                    <div class="p-2 md:p-3 bg-green-100 rounded-lg md:rounded-xl">
                        <svg class="w-4 h-4 md:w-6 md:h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Checked Out -->
            <div class="bg-white rounded-lg md:rounded-2xl p-4 md:p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs md:text-sm font-medium text-gray-600 mb-1">Checked Out</p>
                        <p class="text-xl md:text-3xl font-bold text-amber-600">{{ $stats['checked_out_laptops'] }}</p>
                        <p class="text-xs text-gray-500 mt-1 hidden sm:block">Currently in use</p>
                    </div>
                    <div class="p-2 md:p-3 bg-amber-100 rounded-lg md:rounded-xl">
                        <svg class="w-4 h-4 md:w-6 md:h-6 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- In Maintenance -->
            <div class="bg-white rounded-lg md:rounded-2xl p-4 md:p-6 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs md:text-sm font-medium text-gray-600 mb-1">In Maintenance</p>
                        <p class="text-xl md:text-3xl font-bold text-red-600">{{ $stats['maintenance_laptops'] }}</p>
                        <p class="text-xs text-gray-500 mt-1 hidden sm:block">Under repair</p>
                    </div>
                    <div class="p-2 md:p-3 bg-red-100 rounded-lg md:rounded-xl">
                        <svg class="w-4 h-4 md:w-6 md:h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L5.081 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions Section -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-8 mb-8 md:mb-12">
            <!-- Check-Out Section -->
            <div class="bg-white rounded-xl md:rounded-2xl p-6 md:p-8 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100">
                <div class="flex items-center justify-between mb-4 md:mb-6">
                    <div>
                        <h3 class="text-lg md:text-xl font-bold text-gray-900 mb-1 md:mb-2">Quick Check-Out</h3>
                        <p class="text-sm md:text-base text-gray-600">Scan or manually assign laptops to students</p>
                    </div>
                    <div class="p-3 md:p-4 bg-blue-100 rounded-lg md:rounded-xl">
                        <svg class="w-6 h-6 md:w-8 md:h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                    </div>
                </div>

                <div class="space-y-4">
                    <a href="{{ route('transactions.checkout') }}"
                       class="w-full bg-blue-600 text-white px-4 md:px-6 py-3 rounded-lg md:rounded-xl font-semibold shadow-lg hover:shadow-xl hover:bg-blue-700 transition-all duration-300 flex items-center justify-center space-x-2 md:space-x-3 text-sm md:text-base">
                        <svg class="w-4 h-4 md:w-5 md:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h-1m-9 0H4m9-4v3m-3-3h6M12 12V8"></path>
                        </svg>
                        <span>Check Out Laptop</span>
                    </a>

                    <a href="{{ route('laptops.index') }}"
                       class="w-full bg-gray-100 text-gray-700 px-4 md:px-6 py-3 rounded-lg md:rounded-xl font-medium border border-gray-200 hover:bg-gray-50 hover:shadow-md transition-all duration-300 flex items-center justify-center space-x-2 md:space-x-3 text-sm md:text-base">
                        <svg class="w-4 h-4 md:w-5 md:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <span>View All Laptops</span>
                    </a>
                </div>
            </div>

            <!-- Check-In Section -->
            <div class="bg-white rounded-xl md:rounded-2xl p-6 md:p-8 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-100">
                <div class="flex items-center justify-between mb-4 md:mb-6">
                    <div>
                        <h3 class="text-lg md:text-xl font-bold text-gray-900 mb-1 md:mb-2">Quick Check-In</h3>
                        <p class="text-sm md:text-base text-gray-600">Return laptops and update inventory status</p>
                    </div>
                    <div class="p-3 md:p-4 bg-green-100 rounded-lg md:rounded-xl">
                        <svg class="w-6 h-6 md:w-8 md:h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4"></path>
                        </svg>
                    </div>
                </div>

                <div class="space-y-3 md:space-y-4">
                    <a href="{{ route('transactions.checkin') }}"
                       class="w-full bg-green-600 text-white px-4 md:px-6 py-3 rounded-lg md:rounded-xl font-semibold shadow-lg hover:shadow-xl hover:bg-green-700 transition-all duration-300 flex items-center justify-center space-x-2 md:space-x-3 text-sm md:text-base">
                        <svg class="w-4 h-4 md:w-5 md:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h-1m-9 0H4m9-4v3m-3-3h6M12 12V8"></path>
                        </svg>
                        <span>Check In Laptop</span>
                    </a>

                    <a href="{{ route('reports.index') }}"
                       class="w-full bg-gray-100 text-gray-700 px-4 md:px-6 py-3 rounded-lg md:rounded-xl font-medium border border-gray-200 hover:bg-gray-50 hover:shadow-md transition-all duration-300 flex items-center justify-center space-x-2 md:space-x-3 text-sm md:text-base">
                        <svg class="w-4 h-4 md:w-5 md:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                        <span>View Reports</span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Recent Activity & Quick Insights -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 md:gap-8">
            <!-- Recent Transactions -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-xl md:rounded-2xl p-6 md:p-8 shadow-lg border border-gray-100">
                    <div class="flex items-center justify-between mb-4 md:mb-6">
                        <h3 class="text-lg md:text-xl font-bold text-gray-900">Recent Activity</h3>
                        <a href="{{ route('transactions.index') }}" class="text-blue-600 hover:text-blue-700 font-medium text-xs md:text-sm">View All</a>
                    </div>

                    <div class="space-y-3 md:space-y-4">
                        <div class="flex items-center space-x-3 md:space-x-4 p-3 md:p-4 bg-green-50 rounded-lg md:rounded-xl border border-green-200">
                            <div class="w-2 h-2 md:w-3 md:h-3 bg-green-500 rounded-full"></div>
                            <div class="flex-1">
                                <p class="font-medium text-gray-900 text-sm md:text-base">Laptop checked in successfully</p>
                                <p class="text-xs md:text-sm text-gray-600">2 minutes ago</p>
                            </div>
                        </div>

                        <div class="flex items-center space-x-3 md:space-x-4 p-3 md:p-4 bg-blue-50 rounded-lg md:rounded-xl border border-blue-200">
                            <div class="w-2 h-2 md:w-3 md:h-3 bg-blue-500 rounded-full"></div>
                            <div class="flex-1">
                                <p class="font-medium text-gray-900 text-sm md:text-base">Laptop checked out to student</p>
                                <p class="text-xs md:text-sm text-gray-600">15 minutes ago</p>
                            </div>
                        </div>

                        <div class="flex items-center space-x-3 md:space-x-4 p-3 md:p-4 bg-amber-50 rounded-lg md:rounded-xl border border-amber-200">
                            <div class="w-2 h-2 md:w-3 md:h-3 bg-amber-500 rounded-full"></div>
                            <div class="flex-1">
                                <p class="font-medium text-gray-900 text-sm md:text-base">Maintenance completed</p>
                                <p class="text-xs md:text-sm text-gray-600">1 hour ago</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Insights -->
            <div class="space-y-4 md:space-y-6">
                <!-- Alerts Card -->
                <div class="bg-white rounded-xl md:rounded-2xl p-4 md:p-6 shadow-lg border border-gray-100">
                    <div class="flex items-center space-x-2 md:space-x-3 mb-3 md:mb-4">
                        <div class="p-1.5 md:p-2 bg-red-100 rounded-lg">
                            <svg class="w-4 h-4 md:w-5 md:h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L5.081 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                            </svg>
                        </div>
                        <h4 class="font-bold text-gray-900 text-sm md:text-base">Alerts</h4>
                    </div>
                    <div class="space-y-2 md:space-y-3">
                        <div class="p-2 md:p-3 bg-red-50 rounded-lg border-l-4 border-red-400">
                            <p class="text-xs md:text-sm font-medium text-red-800">{{ $stats['maintenance_laptops'] }} laptops in maintenance</p>
                            <p class="text-xs text-red-600">Require attention</p>
                        </div>
                        <div class="p-2 md:p-3 bg-amber-50 rounded-lg border-l-4 border-amber-400">
                            <p class="text-xs md:text-sm font-medium text-amber-800">{{ $stats['checked_out_laptops'] }} laptops checked out</p>
                            <p class="text-xs text-amber-600">Currently in use</p>
                        </div>
                    </div>
                </div>

                <!-- Quick Stats -->
                <div class="bg-white rounded-xl md:rounded-2xl p-4 md:p-6 shadow-lg border border-gray-100">
                    <h4 class="font-bold text-gray-900 mb-3 md:mb-4 text-sm md:text-base">Utilization</h4>
                    <div class="space-y-3 md:space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-xs md:text-sm text-gray-600">Available Rate</span>
                            <span class="font-bold text-gray-900 text-sm md:text-base">
                                @if($stats['total_laptops'] > 0)
                                    {{ round(($stats['available_laptops'] / $stats['total_laptops']) * 100) }}%
                                @else
                                    0%
                                @endif
                            </span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-500 h-2 rounded-full transition-all duration-1000"
                                 style="width: @if($stats['total_laptops'] > 0){{ ($stats['available_laptops'] / $stats['total_laptops']) * 100 }}@else 0 @endif%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .animate-float {
        animation: float 6s ease-in-out infinite;
    }

    .animation-delay-2000 {
        animation-delay: 2s;
    }

    .animation-delay-4000 {
        animation-delay: 4s;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-10px); }
    }

    .animate-fade-in {
        animation: fadeIn 0.6s ease-out;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>
@endsection