<x-guest-layout>
    <x-authentication-card>
        <!-- Header -->
        <div class="text-center mb-8">
            <h2 class="text-3xl font-bold text-gray-800 mb-2">Reset Your Password</h2>
            <p class="text-gray-600">Enter your email address and we'll send you a reset link</p>
        </div>

        <!-- Description -->
        <div class="bg-blue-50 border border-blue-200 rounded-xl p-4 mb-6">
            <div class="flex items-start">
                <svg class="w-5 h-5 text-blue-600 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="text-sm text-blue-800">
                    No worries! Enter your email address below and we'll send you a secure link to reset your password.
                </p>
            </div>
        </div>

        <!-- Status Message -->
        @session('status')
            <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-xl">
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-green-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    <p class="text-green-800 font-medium">{{ $value }}</p>
                </div>
            </div>
        @endsession

        <!-- Validation Errors -->
        <x-validation-errors class="mb-6" />

        <!-- Reset Form -->
        <form method="POST" action="{{ route('password.email') }}" class="space-y-6">
            @csrf

            <!-- Email Field -->
            <div>
                <label for="email" class="block text-sm font-semibold text-gray-700 mb-2">
                    Email Address
                </label>
                <div class="relative">
                    <input id="email" type="email" name="email" :value="old('email')"
                           required autofocus autocomplete="username"
                           class="input-modern w-full px-4 py-3 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none transition-all duration-300"
                           placeholder="Enter your email address">
                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <button type="submit"
                    class="btn-secondary w-full py-3 px-4 rounded-xl text-white font-semibold text-lg shadow-lg hover:shadow-xl transition-all duration-300 flex items-center justify-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                </svg>
                Send Reset Link
            </button>
        </form>

        <!-- Back to Login -->
        <div class="mt-8 text-center">
            <p class="text-gray-600">
                Remember your password?
                <a href="{{ route('login') }}"
                   class="text-[#3A78C0] hover:text-[#2E5C99] font-semibold transition-colors duration-200">
                    Sign in here
                </a>
            </p>
        </div>
    </x-authentication-card>
</x-guest-layout>
