<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // database/migrations/create_transactions_table.php
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('laptop_id')->constrained('laptops');
            $table->foreignId('student_id')->constrained('students');
            $table->foreignId('user_id')->constrained('users'); // Staff member
            $table->enum('type', ['check_out', 'check_in']);
            $table->timestamp('transaction_time');
            $table->text('notes')->nullable();
            $table->string('condition_before')->nullable();
            $table->string('condition_after')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
