<?php
namespace App\Services;

use Milon\Barcode\DNS1D;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;

// app/Services/BarcodeService.php
class BarcodeService
{
    public function generateBarcode($text, $type = 'C128')
    {
        $barcode = new DNS1D();
        return $barcode->getBarcodePNG($text, $type);
    }

    public function generateQRCode($text)
    {
        $qrCode = new QrCode($text);
        $writer = new PngWriter();
        $result = $writer->write($qrCode);
        return base64_encode($result->getString());
    }

    public function generateQRCodeForLaptop($laptop)
    {
        // Create QR code data with laptop information
        $qrData = [
            'asset_tag' => $laptop->asset_tag,
            'barcode' => $laptop->barcode,
            'brand' => $laptop->brand,
            'model' => $laptop->model,
            'serial_number' => $laptop->serial_number,
            'status' => $laptop->status,
            'class' => $laptop->class->name ?? 'No Class',
            'url' => url('/laptops/' . $laptop->id)
        ];

        // Convert to JSON string for QR code
        $qrText = json_encode($qrData);

        return $this->generateQRCode($qrText);
    }
}