<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    protected $fillable = [
        'student_id', 'first_name', 'last_name', 'email', 'class_id', 'is_active'
    ];

    public function class()
    {
        return $this->belongsTo(ClassRoom::class, 'class_id');
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function currentAssignment()
    {
        return $this->hasOne(CurrentAssignment::class);
    }

    public function getFullNameAttribute()
    {
        return $this->first_name . ' ' . $this->last_name;
    }
}
